% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_chart.R
\name{ms_barchart}
\alias{ms_barchart}
\title{barchart object}
\usage{
ms_barchart(data, x, y, group = NULL)
}
\arguments{
\item{data}{a data.frame}

\item{x}{x colname}

\item{y}{y colname}

\item{group}{grouping colname used to split data into series. Optional.}
}
\description{
Creation of a barchart object that can be
inserted in a 'Microsoft' document.
}
\examples{
library(officer)
# example chart_01 -------

chart_01 <- ms_barchart(data = browser_data, x = "browser",
                           y = "value", group = "serie")
chart_01 <- chart_settings( x = chart_01, dir="vertical",
                               grouping="clustered", gap_width = 50 )
chart_01 <- chart_ax_x( x= chart_01, cross_between = 'between',
                           major_tick_mark="out")
chart_01 <- chart_ax_y( x= chart_01, cross_between = "midCat",
                           major_tick_mark="in")


# example chart_02 -------

dat <- structure(list(Species = structure(1:3, .Label = c("setosa",
  "versicolor", "virginica"), class = "factor"), mean = c(5.006,
  5.936, 6.588)), class = "data.frame", .Names = c("Species", "mean"
  ), row.names = c(NA, -3L))

chart_02 <- ms_barchart(data = dat, x = "Species", y = "mean")
chart_02 <- chart_settings( x = chart_02, dir="horizontal" )



# example chart_03 -------

mytheme <- mschart_theme(
  axis_title_x = fp_text(color = "red", font.size = 24, bold = TRUE),
  axis_title_y = fp_text(color = "green", font.size = 12, italic = TRUE),
  grid_major_line_y = fp_border(width = 1, color = "orange"),
  axis_ticks_y = fp_border(width = 1, color = "orange") )

chart_03 <- ms_barchart(data = browser_data, x = "browser",
                              y = "value", group = "serie")
chart_03 <- chart_settings( chart_03, dir="horizontal", grouping="stacked",
                                  gap_width = 150, overlap = 100 )
chart_03 <- chart_ax_x(chart_03, cross_between = 'between',
                             major_tick_mark="out", minor_tick_mark = "none")
chart_03 <- chart_ax_y(chart_03, num_fmt = "0.00", rotation = -90,
                             minor_tick_mark = "none")
chart_03 <- set_theme(chart_03, mytheme)
chart_03 <- chart_data_labels(chart_03, position = "inBase",
                                    show_val = TRUE, separator = ", ", show_cat_name = TRUE)


}
\seealso{
Other 'Office' chart objects: 
\code{\link{ms_areachart}()},
\code{\link{ms_linechart}()},
\code{\link{ms_scatterchart}()}
}
\concept{'Office' chart objects}
