% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_saeRB.R
\name{est_saeRB}
\alias{est_saeRB}
\title{EBLUPs Ratio Benchmarking based on a Univariate Fay-Herriot (Model 1)}
\usage{
est_saeRB(
  formula,
  vardir,
  weight,
  samevar = FALSE,
  MAXITER = 100,
  PRECISION = 1e-04,
  data
)
}
\arguments{
\item{formula}{an object of class list of formula describe the fitted model}

\item{vardir}{vector containing sampling variances of direct estimators}

\item{weight}{vector containing proportion of units in small areas}

\item{samevar}{logical. If \code{TRUE}, the varians is same. Default is \code{FALSE}}

\item{MAXITER}{maximum number of iterations for Fisher-scoring. Default is 100}

\item{PRECISION}{coverage tolerance limit for the Fisher Scoring algorithm. Default value is \code{1e-4}}

\item{data}{dataframe containing the variables named in formula, vardir, and weight}
}
\value{
This function returns a list with following objects:
\item{eblup}{a list containing a value of estimators}
\itemize{
  \item est.eblup : a dataframe containing EBLUP estimators
  \item est.eblupRB : a dataframe containing ratio benchmark estimators
}

\item{fit}{a list contining following objects:}
\itemize{
  \item method : fitting method, named "REML"
  \item convergence : logical value of convergence of Fisher Scoring
  \item iterations : number of iterations of Fisher Scoring algorithm
  \item estcoef : a data frame containing estimated model coefficients (\code{beta, std. error, t value, p-value})
  \item refvar : estimated random effect variance
}
\item{random.effect}{a data frame containing values of random effect estimators}
\item{agregation}{a data frame containing agregation of direct, EBLUP, and ratio benchmark estimation}
}
\description{
This function gives EBLUPs ratio benchmarking based on univariate Fay-Herriot (model 1)
}
\examples{
## load dataset
data(datamsaeRB)

# Compute EBLUP and Ratio Benchmark using auxiliary variables X1 and X2 for each dependent variable

## Using parameter 'data'
est_sae = est_saeRB(Y1 ~ X1 + X2, v1, w1, data = datamsaeRB)

## Without parameter 'data'
est_sae = est_saeRB(datamsaeRB$Y1 ~ datamsaeRB$X1 + datamsaeRB$X2, datamsaeRB$v1, datamsaeRB$w1)

## Return
est_sae$eblup$est.eblupRB # to see the Ratio Benchmark estimators

}
