% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape_wide_tidyr.R
\name{reshape_wide_tidyr}
\alias{reshape_wide_tidyr}
\title{Reshape dataset to wide format - tidyr version}
\usage{
reshape_wide_tidyr(
  df,
  case_id_var,
  time_id_var,
  timevar_max = 6,
  datsize = Inf
)
}
\arguments{
\item{df}{dataframe}

\item{case_id_var}{String with name of ID variable indicating same patient.
E.g. \code{idvar="PUBCSNUM"} for SEER data.}

\item{time_id_var}{String with name of variable that indicates diagnosis per patient.
E.g. \code{timevar="SEQ_NUM"} for SEER data.}

\item{timevar_max}{Numeric; default 6. Maximum number of cases per id.
All tumors > timevar_max will be deleted before reshaping.}

\item{datsize}{Number of rows to be taken from df. This parameter is mainly for testing. Default is Inf so that df is fully processed.}
}
\value{
df
}
\description{
Reshape dataset to wide format - tidyr version
}
\examples{

data(us_second_cancer)

msSPChelpR::reshape_wide_tidyr(us_second_cancer,
                         case_id_var = "fake_id", 
                         time_id_var = "SEQ_NUM", 
                         timevar_max = 2,
                         datsize = 10000)

}
