% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\docType{methods}
\name{as_bmat}
\alias{as_bmat}
\alias{as_bmat,list-method}
\alias{as_bmat,numeric-method}
\alias{as_bmat,data.frame-method}
\alias{as_bmat,ANY-method}
\alias{as_dmat}
\alias{as_dmat,list-method}
\alias{as_dmat,ANY-method}
\alias{as_dmat,numeric-method}
\alias{as_dmat,data.frame-method}
\title{Coerce R objects to block or diagonal matrices}
\usage{
as_bmat(x, ...)

\S4method{as_bmat}{list}(x, ...)

\S4method{as_bmat}{numeric}(x, pat = "*", ...)

\S4method{as_bmat}{data.frame}(x, pat = "*", cols = NULL, ...)

\S4method{as_bmat}{ANY}(x, ...)

as_dmat(x, ...)

\S4method{as_dmat}{list}(x, ...)

\S4method{as_dmat}{ANY}(x, ...)

\S4method{as_dmat}{numeric}(x, pat = "*", ...)

\S4method{as_dmat}{data.frame}(x, pat = "*", cols = NULL, ...)
}
\arguments{
\item{x}{an R object}

\item{...}{passed along}

\item{pat}{regular expression, character}

\item{cols}{column names to use instead of \code{pat}}
}
\value{
A numeric matrix for list and numeric methods.  For data.frames, 
a list of matrices are returned.
}
\description{
Coerce R objects to block or diagonal matrices
}
\examples{

df <- data.frame(OMEGA1.1 = c(1,2),
                 OMEGA2.1 = c(11,22),
                 OMEGA2.2 = c(3,4),
                 SIGMA1.1 = 1,
                 FOO=-1)

as_bmat(df, "OMEGA")
as_dmat(df,"SIGMA")
as_dmat(df[1,],"OMEGA")

}
\seealso{
\code{\link{bmat}}, \code{\link{dmat}}
}
