% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr_features_get.R
\name{mr_features_get}
\alias{mr_features_get}
\title{Get features}
\usage{
mr_features_get(type, featureID, maxFeatures = 100, format = "json",
  path = NULL, ...)
}
\arguments{
\item{type}{(character) a region type, e.g., "MarineRegions:eez". required}

\item{featureID}{(character) a feature ID. required}

\item{maxFeatures}{(integer) Number of features. Default: 100}

\item{format}{(character) output format, see Details for allowed options.
Default: json}

\item{path}{(character) required when \code{format="SHAPE-ZIP"},
otherwise, ignored}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
depends on the \code{format} option used, usually a text string
}
\description{
Get features
}
\details{
Allowed options for the \code{format} parameter:
\itemize{
 \item \code{text/xml; subtype=gml/3.2}
 \item \code{GML2}
 \item \code{KML}
 \item \code{SHAPE-ZIP}
 \item \code{application/gml+xml; version=3.2}
 \item \code{application/json}
 \item \code{application/vnd.google-earth.kml xml}
 \item \code{application/vnd.google-earth.kml+xml}
 \item \code{csv}
 \item \code{gml3}
 \item \code{gml32}
 \item \code{json}
 \item \code{text/xml; subtype=gml/2.1.2}
 \item \code{text/xml; subtype=gml/3.1.1}
}
}
\examples{
\dontrun{
# json by default
mr_features_get(type = "MarineRegions:eez", featureID = "eez.3")
# csv
mr_features_get(type = "MarineRegions:eez", featureID = "eez.3",
  format = "csv")
# KML
mr_features_get(type = "MarineRegions:eez", featureID = "eez.3",
  format = "KML")
# if you want SHAPE-ZIP, give a file path
file <- tempfile(fileext = ".zip")
mr_features_get(type = "MarineRegions:eez", featureID = "eez.3",
  format = "SHAPE-ZIP", path = file)
file.exists(file)
unlink(file)
# glm32
mr_features_get(type = "MarineRegions:eez", featureID = "eez.3",
  format = "gml32")
}
}

