% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detfct.fit.R
\name{detfct.fit}
\alias{detfct.fit}
\title{Fit detection function using key-adjustment functions}
\usage{
detfct.fit(ddfobj, optim.options, bounds, misc.options)
}
\arguments{
\item{ddfobj}{detection function object}

\item{optim.options}{control options for optim}

\item{bounds}{bounds for the parameters}

\item{misc.options}{miscellaneous options}
}
\value{
fitted detection function model object with the following list
  structure \item{par}{final parameter vector} \item{value}{final negative
  log likelihood value} \item{counts}{number of function evaluations}
  \item{convergence}{see codes in optim} \item{message}{string about
  convergence} \item{hessian}{hessian evaluated at final parameter values}
  \item{aux}{ a list with 20 elements \itemize{ \item maxit: maximum number
  of iterations allowed for optimization \item lower: lower bound values for
  parameters \item upper: upper bound values for parameters \item setlower:
  TRUE if they are user set bounds \item setupper: TRUE if they are user set
  bounds \item point: TRUE if point counts and FALSE if line transect \item
  int.range: integration range values \item showit: integer value that
  determines information printed during iteration \item integral.numeric
  if TRUE compute logistic integrals numerically \item
  breaks: breaks in distance for defined fixed bins for analysis \item
  maxiter: maximum iterations used \item refit: if TRUE, detection function
  will be fitted more than once if parameters are at a boundary or when
  convergence is not achieved \item nrefits: number of refittings \item
  \item mono: if TRUE montonicity will be enforced \item
  mono.strict: if TRUE, then strict monotonicity is enforced; otherwise weak
  \item width: radius of point count or half-width of strip \item
  standardize: if TRUE, detection function is scaled so g(0)=1 \item ddfobj:
  distance detection function object; see \code{\link{create.ddfobj}} \item
  bounded: TRUE if parameters ended up a boundary (I think) \item model:
  list of formulas for detection function model (probably can remove this)
  }}
}
\description{
Fit detection function to observed distances using the key-adjustment
function approach.  If adjustment functions are included it will alternate
between fitting parameters of key and adjustment functions and then all
parameters much like the approach in the CDS and MCDS Distance FORTRAN code.
To do so it calls \code{detfct.fit.opt} which uses the R optim function
which does not allow non-linear constraints so inclusion of adjustments does
allow the detection function to be non-monotone.
}
\author{
Dave Miller; Jeff Laake
}
