% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelpFunctions.R
\name{ifftshift}
\alias{ifftshift}
\title{Inverse FFT shift of a 2d matrix.}
\usage{
ifftshift(inputMatrix, dimension = -1)
}
\arguments{
\item{inputMatrix}{Matrix to be swapped.}

\item{dimension}{Which swap should be performed? 
\itemize{
    \item \code{1}: swap halves along the rows.
    \item \code{2}: swap halves along the columns. 
    \item \code{-1}: swap first quadrant with third and second quadrant with fourth. 
}}
}
\value{
Swapped matrix.
}
\description{
\code{ifftshift} is an R equivalent to the Matlab function \code{ifftshift} 
applied on matrices. For more information about \code{ifftshift} see 
the Matlab documentation.
}
\details{
\code{ifftshift} is the inverse function to \code{\link{fftshift}}. For more
information see the details of \code{\link{fftshift}}
}
\examples{
set.seed(987)
sampleMat <- matrix(sample(1:10, size = 25, replace = TRUE), nrow = 5)

# Swap halves along the rows:
ifftshift(sampleMat, dimension = 1)

# Swap halves along the columns:
ifftshift(sampleMat, dimension = 2)

# Swap first quadrant with third and second quadrant with fourth:
ifftshift(sampleMat, dimension = -1)

}
