% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_experimental_design.R
\name{load_experimental_design}
\alias{load_experimental_design}
\title{Load and Prepare the input data with experimental design file}
\usage{
load_experimental_design(path)
}
\arguments{
\item{path}{Path to folder with experimental design file. Within exp_design.csv the user needs to specify the analysis name, software and path to analysis folder. Also specific default suffixes are required: for MaxQuant: _evidence, _peptides, _proteinGroups; for PD - R-friendly headers enabled: _PSMs, _Proteins, _PeptideGroups, _ProteinGroups; for DIA-NN, Spectronaut and Generic: _Report}
}
\value{
A list - each list entry has filename and software info as well as stored data.
}
\description{
Based on submitted experimental design file the input data will be imported, renamed and default filtering will be applied. An experimental design template is available with write_experimental_design.
}
\details{
Function for easily importing the default software outputs and preparing for downstream analysis with mpwR from multiple analysis folders. As default for MaxQuant "Reverse", "Potential contaminants" and "Only identified by site" are filtered out. As default for PD only "High" confidence identifications are included and for Found in Sample column(s) also only "High" identifications. Contaminants are filtered out. As default for Spectronaut only EG.Identified equals TRUE are included.
}
\examples{
\dontrun{
#get template with write_experimental_design and adjust inputs
write_experimental_design("DIRECTORY_TO_FILE")

#load in data
files <- load_experimental_design(path = "DIRECTORY_TO_FILE/your_exp_design.csv")
}
}
\author{
Oliver Kardell
}
