% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_DC_Report.R
\name{get_DC_Report}
\alias{get_DC_Report}
\title{Data Completeness Report}
\usage{
get_DC_Report(input_list, metric = c("absolute", "percentage"))
}
\arguments{
\item{input_list}{A list with data frames and respective level information.}

\item{metric}{\code{"absolute"} for absolute numbers or \code{"percentage"} for displaying percentages. Default is absolute.}
}
\value{
This function returns a list. For each analysis a respective data frame including missing value information per level is stored in the generated list.
\itemize{
\item Analysis - analysis name.
\item Nr.Missing.Values - number of missing values.
\item Precursor.IDs - number of precursor identification per missing value entry - absolute or in percentage.
\item Peptide.IDs - number of peptide identification per missing value entry - absolute or in percentage.
\item Protein.IDs - number of protein identification per missing value entry - absolute or in percentage.
\item ProteinGroup.IDs - number of proteingroup identification per missing value entry - absolute or in percentage.
\item Profile - categorical entries: "unique", "sparse", "shared with at least 50\%" or "complete".
}
}
\description{
Generates a data completeness report from precursor to proteingroup-level
}
\details{
For each submitted data a data completeness report is generated highlighting missing values on precursor-, peptide-, protein- and proteingroup-level.
}
\examples{
# Load libraries
library(tibble)
library(stringr)

# Example data
data <- list(
DIANN = list(
  filename = "B",
  software = "DIA-NN",
  data = list(
     "DIA-NN" = tibble::tibble(
        Run_mpwR = rep(c("A","B"), times = 10),
        Precursor.IDs_mpwR = rep(c("A2", "A3", "B2", "B3", "C1"), each = 4),
        Protein.IDs_mpwR = rep(c("A2", "A3", "B2", "B3", "C1"), each = 4),
        Peptide.IDs_mpwR = rep(c("A", "A", "B", "B", "C"), each = 4),
        ProteinGroup.IDs_mpwR = rep(c("A2", "A3", "B2", "B3", "C1"), each = 4)
     )
  )
)
)

# Result
output <- get_DC_Report(
  input_list = data,
  metric = "absolute"
)
}
\author{
Oliver Kardell
}
