% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_animate.R
\name{mp_animate}
\alias{mp_animate}
\title{Animate the output of a RAMAS Metapop simulation.}
\usage{
mp_animate(dat, habitat, outfile, zlim, axes = FALSE, col.regions = NULL,
  pt.col = NULL, pt.cex = 1, height = 800, width = 800,
  interval = 0.05, label = TRUE, label.pos = c(0.98, 0.05),
  label.just = "right", label.cex = 1.5, label.font = 2,
  overwrite = FALSE)
}
\arguments{
\item{dat}{A \code{SpatialPointsDataFrame} object returned by 
\code{\link{mp2xy}}.}

\item{habitat}{A RasterStack or RasterBrick object. The number of Raster 
layers should equal the number of simulation time steps. Further, the 
layers should be ordered temporally, and should correspond to the levels of
\code{dat$time}. It is assumed that the time step between layers is 
consistent (i.e., the interval between animation frames is constant).}

\item{outfile}{A character string giving the desired output path and 
filename.}

\item{zlim}{A numeric vector of length 2 giving the lower and upper limits of
the color scale indicating habitat quality. If this is not provided, a 
pretty range will be calculated (though this will impact efficiency).}

\item{axes}{Logical. Should axes be drawn?}

\item{col.regions}{A \code{\link{colorRampPalette}} function that will be 
used to generate the colour ramp for grids. If \code{NULL}, a default 
colour ramp based on \code{\link{terrain.colors}} is used.}

\item{pt.col}{A \code{\link{colorRampPalette}} function that will be used
to generate the colour ramp for points. These colours will be interpolated 
into 100 colours, which indicate relative mean population size, ranging 
from 1 (first element of the colour ramp) to the maximum mean population 
size that exists in the simulation output. If \code{NULL}, a default colour
ramp ranging from white to black is used.}

\item{pt.cex}{Point size magnifier, relative to the default.}

\item{height}{Numeric. The height of the animation, in pixels. Default is 
800.}

\item{width}{Numeric. The width of the animation, in pixels. Default is 800.}

\item{interval}{The time interval of the animation, in seconds. Default is 
0.05, i.e. 20 frames per second.}

\item{label}{Should a time step counter be plotted?}

\item{label.pos}{A vector of two numbers giving the normalised parent
coordinates at which the time step counter will be plotted. The first
number gives the x-coordinate (0 = left edge, 1 = right edge) and the
second gives the y-coordinate (0 = bottom edge, 1 = top edge). The default
value of \code{c(0.98, 0.05)} plots the label at the bottom right corner. 
Ignored if \code{label} is \code{FALSE}.}

\item{label.just}{Justification of the time step counter label, relative to
\code{label.pos}. See the description of \code{just} at
\code{\link{grid.text}}. Ignored if \code{label} is \code{FALSE}.}

\item{label.cex}{Size of the time step counter text. Ignored if \code{label}
is \code{FALSE}.}

\item{label.font}{Font face of the time step counter text. See
\code{fontface} at \code{\link{gpar}} for available options. Ignored if
\code{label} is \code{FALSE}.}

\item{overwrite}{Should \code{outfile} be overwritten if it already exists?}
}
\value{
\code{NULL}. The animation is saved as an animated .gif file at the
  specified path (\code{outfile}).
}
\description{
Animate temporal habitat and abundance dynamics on a gridded landscape.
}
\details{
\code{mp_animate} requires that either 
  \href{ImageMagick}{http://www.imagemagick.org} or 
  \href{GraphicsMagick}{http://www.graphicsmagick.org} are installed on the 
  system. See the documentation for 
  \code{animation::\link[animation]{im.convert}} for further details.
  
  An animated gif is created, with points indicating the location of
  populations with mean abundance greater than zero, overlaid upon a raster
  grid indicating habitat suitability. Relative population size is
  represented by point colour, with white corresponding to a population with 
  mean abundance between 0 and 1% of the maximum mean abundance across all
  populations and time steps, and black corresponding to the maximum mean
  abundance. Colours for intermediate values are scaled linearly. The colour
  key indicates carrying capacity, and corresponds to the colour of grid
  cells.
 
  An example of this function's use is provided in the vignette "Introduction 
  to mptools" (\code{vignette('intro', 'mptools')}).
}
\seealso{
\code{\link{mp2sp}}
}
\keyword{spatial}

