% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{actions}
\alias{actions}
\title{Extract Metapop management action details}
\usage{
actions(mp)
}
\arguments{
\item{mp}{A character string containing the path to a RAMAS Metapop .mp file.}
}
\value{
A \code{data.frame} containing one row per management action, with 
  columns: \item{do.action}{Logical. Will the action be performed 
  (\code{TRUE}) or ignored (\code{FALSE}).} \item{action}{Factor. The type of
  action to be performed.} \item{sourcepop}{The identity of the source 
  population.} \item{targetpop}{The identity of the target population.} 
  \item{start}{The timestep at which the action will commence.} 
  \item{end}{The timestep at which the action will end.} \item{freq}{The 
  frequency of the action, in timestep units.} 
  \item{after.dispersal}{Logical. Whether the action will be performed after 
  (\code{TRUE}) or before (\code{FALSE}) dispersal has taken place.} 
  \item{quantity}{Factor. Whether the action affects an absolute 
  \code{number} of individuals, or a \code{proportion} of the source 
  population.} \item{number}{The absolute number of individuals involved in 
  the action.} \item{proportion}{The proportion of the source population 
  involved in the action.} \item{fromstage}{The lowest stage involved in the 
  action.} \item{tostage}{The highest stage involved in the action.} 
  \item{condition}{The condition under which the action will be performed.} 
  \item{thr1}{If \code{condition} is either \code{N<thr1} or 
  \code{N<thr1_and_N>thr2}, this is the abundance threshold \code{thr1}.} 
  \item{thr2}{If \code{condition} is either \code{N>thr2} or 
  \code{N<thr1_and_N>thr2}, this is the abundance threshold \code{thr2}.} 
  \item{unknownfield}{Unknown.} \item{linear.to}{If \code{condition} is 
  \code{linear}, this is the upper quantity (absolute number, or proportion, 
  depending on \code{quantity}) towards which linear change will move.} 
  \item{linear.lowerN}{If \code{condition} is \code{linear}, this is the 
  abundance at which the quantity affected is equal to \code{number} or 
  \code{proportion}, depending on the value of \code{quantity}.} 
  \item{linear.upperN}{If \code{condition} is \code{linear}, this is the 
  abundance at which the quantity affected is equal to \code{linear.to}.} 
  \item{N.comprises.stages}{Factor. The stages included in the definition of 
  N, when calculating \code{thr1}, \code{thr2}, \code{linear.lowerN} and 
  \code{linear.upperN}.} \item{N.comprises.pops}{Factor. The populations
  included in the definition of N, when calculating \code{thr1}, \code{thr2},
  \code{linear.lowerN} and \code{linear.upperN}.}
}
\description{
Extract management action details from RAMAS Metapop .mp files.
}

