#' mptools: Extract, summarise and visualise RAMAS Metapop model information
#' 
#' \href{https://www.ramas.com/ramas.htm#metapop}{RAMAS Metapop} is a popular
#' software package for performing spatially-explicit population viability
#' analysis. It is primarily GUI-driven, and stores metapopulation model
#' parameter settings and simulation results in plain text files (.mp files).
#' This package facilitates access, summary and visualisation of Metapop outputs 
#' in order to better integrate RAMAS analyses into an R workflow.
#' @note \code{mptools} has been tested with outputs generated by RAMAS Metapop
#' version 5, and may produce unexpected results for other versions. When using 
#' \code{\link{results}}, \code{\link{meta}}, \code{\link{mp2xy}}, or
#' \code{\link{actions}} a warning is issued if the user attempts to access
#' files originating from other versions of RAMAS Metapop.
#' 
#' @references \itemize{
#'   \item{Akcakaya, H. R., Burgman, M. A., Kindvall, O., Wood, C. C., 
#'   Sjogren-Gulve, P., Hatfield, J. S., & McCarthy, M. A. (2004). \emph{Species
#'   Conservation and Management: Case Studies}. New York: Oxford University
#'   Press.}
#'   \item{\href{https://www.ramas.com/ramas.htm#metapop}{RAMAS Software}}
#'   \item{\href{https://www.ramas.com/gis-faq.htm}{RAMAS GIS and RAMAS Metapop
#'   Frequently Asked Questions}}
#' }
#' @docType package
#' @name mptools
NULL
