% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_allele_eff_GE.R
\name{plot_allele_eff_GE}
\alias{plot_allele_eff_GE}
\title{plot of genome wide QTL allelic effect significance}
\usage{
plot_allele_eff_GE(
  mppData,
  nEnv,
  EnvNames,
  Qprof,
  Q.eff = "par",
  QTL = NULL,
  ref_par = NULL,
  main = "QTL genetic effects plot",
  text.size = 18
)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{nEnv}{\code{Numeric} number of environment or trait.}

\item{EnvNames}{\code{character} expression indicating the environment or trait
labels.}

\item{Qprof}{object obtained with function \code{\link{mppGE_SIM}},
\code{\link{mppGE_CIM}},}

\item{Q.eff}{one of "cr", "par", "anc" or "biall". For the moment only "par"
is available.}

\item{QTL}{Optional argument. Object of class \code{QTLlist} representing a
list of selected position obtained with the function \code{\link{QTL_select}}
or a vector of \code{character} marker or in between marker positions names.
These positions will be plotted on the graph. Default = NULL.}

\item{ref_par}{\code{Charater} specifying the reference parent. Default = NULL.}

\item{main}{Title of the graph. Default = "QTL genetic effects plot".}

\item{text.size}{\code{Numeric} value specifying the size of graph axis text
elements. Default = 18.}
}
\description{
Plot of the genome wide significance of the QTL allelic effects in multiple
environments.
}
\examples{

data(mppData_GE)

SIM <- mppGE_SIM(mppData = mppData_GE, trait = c('DMY_CIAM', 'DMY_TUM'))

Qpos <- QTL_select(Qprof = SIM, threshold = 3, window = 50)

plot_allele_eff_GE(mppData = mppData_GE, nEnv = 2, EnvNames = c('CIAM', 'TUM'),
                   Qprof = SIM, Q.eff = 'par', QTL = Qpos, text.size = 14)

}
\seealso{
\code{\link{mppGE_CIM}}, \code{\link{mppGE_SIM}}
}
\author{
Vincent Garin
}
