% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{update.cmp}
\alias{update.cmp}
\title{Update and Re-fit a COM-Poisson Model}
\usage{
\method{update}{cmp}(object, formula., ..., evaluate = TRUE)
}
\arguments{
\item{object}{an object class 'cmp', obtained from a call to \code{glm.cmp}.}

\item{formula.}{changes to the existing formula in \code{object} -- see \code{update.formula}
for details}

\item{...}{other arguments passed to or from other methods  (currently unused).}

\item{evaluate}{logical; if \code{TRUE} evaluate the new call otherwise simply ruturn 
the call}
}
\description{
\code{update} (i.e., \code{update.cmp}) will upate and (by-default) re-fit a model. It is
identical to \code{update} in the \code{stats} package.
}
\examples{
data(takeoverbids)

## Fit full model 
M.bids.full <- glm.cmp(numbids ~ leglrest + rearest + finrest + whtknght 
    + bidprem + insthold + size + sizesq + regulatn, data=takeoverbids)
M.bids.full
        
## Dropping whtknght
M.bids.null <- update(M.bids.full, .~.-whtknght)
M.bids.null

}
\seealso{
\code{\link{glm.cmp}}, \code{\link{update.formula}}, \code{\link{cmplrtest}}.
}
