% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{index_db}
\alias{index_db}
\title{Create indexes for an mpathsenser database}
\usage{
index_db(db)
}
\arguments{
\item{db}{A database connection to an m-Path Sense database.}
}
\value{
Returns \code{TRUE} invisibly, called for side effects.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Create indexes for an mpathsenser database on the \code{participant_id}, \code{date}, and a combination
of these variable for all the tables in the database. This will speed up queries that use these
variables in the \code{WHERE} clause.
}
\examples{
\dontrun{
# First create a database in a temporary directory
db <- create_db(tempdir(), "mydb.db")

# Import some files
import(path = "path/to/jsons", db = db)

# Then index it to speed up the database
index_db(db)
}
}
