% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alias_column_names.R
\name{alias_column_names}
\alias{alias_column_names}
\title{Alias column names of a data frame containing sensor data}
\usage{
alias_column_names(data, ...)
}
\arguments{
\item{data}{A data frame for which the column names are remapped according to the specific method
for this data frame. As such, \code{data} should have a class attribute that corresponds to one of
the methods defined in this file.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A data frame with the column names remapped according to the specific method for this
data frame.
}
\description{
This function is used to remap the column names of a data frame containing sensor data to the
column names used in the database schema of mpathsenser. As the column names have already
changed several times over the year, we use these functions so we can easily add new aliases of
the existing columns. The function is generic and dispatches to the specific method for the
class of \code{data}.
}
\details{
Aliasing of the column names depends on the specific method, but column names are only changed
if they have an alias available. Otherwise, they are kept unchanged.
}
\examples{
x <- data.frame(
  id = 1:3,
  timestamp = as.POSIXct(c("2021-01-01 00:00:00", "2021-01-01 00:00:01", "2021-01-01 00:00:02")),
  xm = c(1, 2, 3),
  ym = c(4, 5, 6),
  zm = c(7, 8, 9)
)
class(x) <- c("accelerometer", class(x))
mpathsenser:::alias_column_names(x)
}
\keyword{internal}
