% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_pactr-accessors.R
\name{get_cv_data}
\alias{get_cv_data}
\title{Get CV values.}
\usage{
get_cv_data(mpactr_object)
}
\arguments{
\item{mpactr_object}{The mpactr object that is created by calling
the import_data() function.}
}
\value{
a \code{data.table} reporting the mean and median coefficient
of variation for each input ion.
}
\description{
\code{get_cv_data()} is a wrapper function to return cv (coefficient of
variation) calculated with \code{\link[=filter_cv]{filter_cv()}}.
}
\examples{
data <- import_data(
  example_path("coculture_peak_table.csv"),
  example_path("metadata.csv"),
  format = "Progenesis"
)

data_filter <- filter_cv(data,
  cv_threshold = 0.01,
  cv_param = "median"
)

cv <- get_cv_data(data_filter)
head(cv)

}
