% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAllFunnels.R
\name{getAllFunnelsIncAIC}
\alias{getAllFunnelsIncAIC}
\title{Get all funnels, including AIC lines}
\usage{
getAllFunnelsIncAIC(cross, standardised = FALSE)
}
\arguments{
\item{cross}{The object of class \code{mpcross} containing the pedigree of interest}

\item{standardised}{Should the output funnels be standardised?}
}
\value{
Matrix of mixing orders that contribute to the final popluation. Rows DO NOT refer to specific genetic lines.
}
\description{
Get every order of the founding lines, which makes a contribution to the final population
}
\details{
This function is similar to \code{\link{getAllFunnels}}, but more useful for populations with maintenance (or AIC) generations. It returns a list of all the mixing orders in the initial generations, which make a genetic contribution to the final population. Unlike for \code{\link{getAllFunnels}}, rows of the returned matrix DO NOT refer to specific genetic lines.
}
\examples{
set.seed(1)
pedigree <- fourParentPedigreeRandomFunnels(initialPopulationSize = 1000,
     selfingGenerations = 6, intercrossingGenerations = 1)
#Assume infinite generations of selfing in subsequent analysis
selfing(pedigree) <- "infinite"
#Generate random map
map <- qtl::sim.map(len = 100, n.mar = 101, anchor.tel = TRUE, include.x = FALSE)
#Simulate data
cross <- simulateMPCross(map = map, pedigree = pedigree, mapFunction = haldane, seed = 1L)
#Because we have maintenance in this experiment, we can't get out the funnels per genetic line
funnels <- getAllFunnels(cross)
dim(funnels)
funnels[1:10,]
#But we can get out a list of all the funnels that go into the experiment.
funnels <- getAllFunnelsIncAIC(cross)
dim(funnels)
funnels[1:10,]
}
