% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputationGenerics.R
\name{imputationMap}
\alias{imputationMap}
\alias{imputationMap,imputed-method}
\alias{imputationMap,geneticData-method}
\alias{imputationMap,mpcrossMapped-method}
\title{Get map used for IBD genotype imputation}
\usage{
imputationMap(object, ...)

\S4method{imputationMap}{imputed}(object, ...)

\S4method{imputationMap}{geneticData}(object, ...)

\S4method{imputationMap}{mpcrossMapped}(object, ...)
}
\arguments{
\item{object}{The object from which to extract the IBD genotype imputation positions.}

\item{...}{Extra parameters. Currently only \code{"experiment"} is supported, letting the user extract the imputation map for a specific experiment.}
}
\value{
The map of positions used for IBD genotype imputation.
}
\description{
Get map used for IBD genotype imputation
}
\details{
Get the map of positions used for IBD genotype imputation. This is necessary because the points at which IBD genotype imputation has been performed may include non-marker points. See \code{\link{imputeFounders}} for further details.
}
