% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lsp.R
\name{lsp}
\alias{lsp}
\title{Least-Square Projection}
\usage{
lsp(X, sample.indices = NULL, Ys = NULL, k = 15, q = 2)
}
\arguments{
\item{X}{A data frame or matrix.}

\item{sample.indices}{The indices of data points in X used as subsamples. If
not given, some rows from X will be randomly selected and Ys will be generated
by calling forceScheme on them.}

\item{Ys}{Initial kD configuration of the data subsamples (will be ignored if
sample.indices is NULL).}

\item{k}{Number of neighbors used to build the neighborhood graph.}

\item{q}{The target dimensionality.}
}
\value{
The qD representation of the data.
}
\description{
Creates a q-dimensional representation of multidimensional data. Requires a
subsample (sample.indices) and its qD representation (Ys).
}
\examples{
# Iris example
emb <- lsp(iris[, 1:4])
plot(emb, col=iris$Species)
}
\references{
F. V. Paulovich, L. Nonato, R. Minghim, and H. Levkowitz,
Least-Square Projection: A fast high-precision multidimensional projection
technique and its application to document mapping, vol. 14, no. 3, pp. 564-575.
}

