% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavelet.R
\name{plot_roll_resultant_length}
\alias{plot_roll_resultant_length}
\title{Plot windowed resultant length}
\usage{
plot_roll_resultant_length(
  obj,
  window_duration = 1,
  smooth = FALSE,
  by = 1,
  ref_lines = c(W = 0.7, M = 0.85, H = 0.95),
  align = "right",
  na.rm = TRUE
)
}
\arguments{
\item{obj}{a \code{sel.phases} object.}

\item{window_duration}{duration of window over which to take mean (default is 1 sec).}

\item{smooth}{use the smoothed phase angle data (default is FALSE).}

\item{by}{calculate resultant length at every \code{by}-th time point rather than every point.}

\item{ref_lines}{names list of reference line values (default is \code{c(W = 0.7, M = 0.85, H = 0.95)}).}

\item{align}{alignment of window (default is 'right').}

\item{na.rm}{Remove NAs from the circular mean (default is TRUE).}
}
\value{
a \code{ggplot} object.
}
\description{
Plot windowed resultant length
}
\examples{
r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)
co <- analyze_coherency(pv, columns = c("Nose_x", "Nose_y"))
sp <- plot_sel_phases(co, pv, sel.period = 0.64)
plot_roll_resultant_length(sp, ref_lines = c(H = 0.9998))
}
\seealso{
Other wavelet functions: 
\code{\link{analyze_coherency}()},
\code{\link{analyze_wavelet}()},
\code{\link{get_local_max_average_power}()},
\code{\link{plot_average_coherency}()},
\code{\link{plot_average_power}()},
\code{\link{plot_cross_spectrum}()},
\code{\link{plot_cwt_energy}()},
\code{\link{plot_phase_difference}()},
\code{\link{plot_power_spectrum}()},
\code{\link{plot_sel_phases}()},
\code{\link{plot_wt_energy}()}
}
\concept{wavelet functions}
