% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motion.R
\name{plot_history_xy}
\alias{plot_history_xy}
\title{Plot a set of data points over time}
\usage{
plot_history_xy(obj, maxpts = 10000)
}
\arguments{
\item{obj}{\code{View} object.}

\item{maxpts}{maximum number of points to plot.}
}
\value{
a \code{ggplot} object.
}
\description{
Plot a set of data points over time
}
\examples{
r1 <- get_sample_recording()
rv1 <- get_raw_view(r1, "Central", "", "Sitar")
pv1 <- get_processed_view(rv1)
fv1 <- apply_filter_sgolay(pv1, data_points = c("LElbow", "RElbow"), n = 41, p = 3)
sub_fv1 <- subset(fv1, Time >= 0 & Time <= 100, by = 10)
plot_history_xy(sub_fv1)
}
