% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_joined_view}
\alias{get_joined_view}
\title{Get joined view from multiple views from the same recording}
\usage{
get_joined_view(l, folder_out = "Joined", save_output = FALSE)
}
\arguments{
\item{l}{named list of \code{View} objects.}

\item{folder_out}{output folder relative to recording home (default is 'Joined').}

\item{save_output}{save the output?}
}
\value{
JoinedView object
}
\description{
Get joined view from multiple views from the same recording
}
\examples{
r <- get_sample_recording()
rv_list <- get_raw_views(r)
jv <- get_joined_view(rv_list)
plot(jv, columns = c("LEar_x_Central_Sitar", "LEar_x_Central_Tabla"), yax.flip=TRUE)
}
\seealso{
Other data functions: 
\code{\link{apply_filter_sgolay}()},
\code{\link{get_data_points}()},
\code{\link{get_duration_annotation_data}()},
\code{\link{get_feature_data}()},
\code{\link{get_filtered_views}()},
\code{\link{get_metre_data}()},
\code{\link{get_onsets_selected_data}()},
\code{\link{get_processed_views}()},
\code{\link{get_processed_view}()},
\code{\link{get_raw_optflow_view}()},
\code{\link{get_raw_views}()},
\code{\link{get_raw_view}()},
\code{\link{get_recording}()},
\code{\link{get_sample_recording}()}
}
\concept{data functions}
