% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_feature_data}
\alias{get_feature_data}
\title{Get Feature Data}
\usage{
get_feature_data(
  recording,
  vid,
  direct,
  inst,
  interpolate_data = FALSE,
  folder_out = tempdir(),
  save_output = FALSE,
  filetype = "rda",
  verbose = FALSE
)
}
\arguments{
\item{recording}{\code{Recording} object.}

\item{vid}{camera.}

\item{direct}{direction.}

\item{inst}{instrument.}

\item{interpolate_data}{should the data be interpolated? (default is FALSE).}

\item{folder_out}{output folder relative to recording home (default is 'tempdir()').}

\item{save_output}{save the output?}

\item{filetype}{type of file ('rda' as default), can be 'csv'.}

\item{verbose}{messages the specific data loaded (default is 'FALSE').}
}
\value{
a \code{FilteredView} object.
}
\description{
Output from new analysis process that generates data at the same sample
rate as the video data. The user is responsible for ensuring that this
data is continuous before using this function.
}
\examples{
r <- get_sample_recording()
fd <- get_feature_data(r, "Central" ,"", "Sitar")
fv_list <- get_filtered_views(r, 'LEar', n = 41, p =3)
fv_list$Feature <- fd
jv <- get_joined_view(fv_list)
get_data_points(jv)
autoplot(jv)
}
\seealso{
Other data functions: 
\code{\link{apply_filter_sgolay}()},
\code{\link{get_data_points}()},
\code{\link{get_duration_annotation_data}()},
\code{\link{get_filtered_views}()},
\code{\link{get_joined_view}()},
\code{\link{get_metre_data}()},
\code{\link{get_onsets_selected_data}()},
\code{\link{get_processed_views}()},
\code{\link{get_processed_view}()},
\code{\link{get_raw_optflow_view}()},
\code{\link{get_raw_views}()},
\code{\link{get_raw_view}()},
\code{\link{get_recording}()},
\code{\link{get_sample_recording}()}
}
\concept{data functions}
