% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n2w.R
\name{n2w}
\alias{n2w}
\title{Scaling function: natural to working parameters.}
\usage{
n2w(par, bounds, beta, delta = NULL, nbStates, estAngleMean)
}
\arguments{
\item{par}{Vector of state-dependent distributions parameters.}

\item{bounds}{Matrix with 2 columns and as many rows as there are elements in \code{par}. Each row
contains the lower and upper bound for the correponding parameter.}

\item{beta}{Matrix of regression coefficients for the transition probabilities.}

\item{delta}{Initial distribution. Default: \code{NULL} ; if the initial distribution is not estimated.}

\item{nbStates}{The number of states of the HMM.}

\item{estAngleMean}{\code{TRUE} if the angle mean is estimated, \code{FALSE} otherwise.}
}
\value{
A vector of unconstrained parameters.
}
\description{
Scales each parameter from its natural interval to the set of real numbers, to allow for
unconstrained optimization. Used during the optimization of the log-likelihood.
}
\examples{
\dontrun{
nbStates <- 3
par <- c(0.001,0.999,0.5,0.001,1500.3,7.1)
bounds <- matrix(c(0,1, # bounds for first parameter
                   0,1, # bounds for second parameter
                   0,1, # ...
                   0,Inf,
                   0,Inf,
                   0,Inf),
                 byrow=TRUE,ncol=2)
beta <- matrix(rnorm(18),ncol=6,nrow=3)
delta <- c(0.6,0.3,0.1)

# vector of working parameters
wpar <- n2w(par=par,bounds=bounds,beta=beta,delta=delta,nbStates=nbStates,
           estAngleMean=FALSE)
}

}

