% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_track_id.R
\name{mt_track_lines}
\alias{mt_track_lines}
\title{Convert trajectories into lines}
\usage{
mt_track_lines(x, ...)
}
\arguments{
\item{x}{A move object}

\item{...}{Arguments passed on to the \link[dplyr:summarise]{summarise} function}
}
\value{
A \link[sf:sf]{sf::sf} object with a line representing the track as geometry for each track.
}
\description{
Converts each track into one line
}
\details{
Note that all empty points are removed before summarizing. Arguments passed with \code{...} thus only summarize for the
non empty locations.
}
\examples{
mt_sim_brownian_motion() |>
  mt_track_lines(
    n = dplyr::n(),
    minTime = min(time),
    maxTime = max(time)
  )
## empty points are not counted in summary statistic
x <- mt_sim_brownian_motion(1:3)
x$geometry[[2]] <- sf::st_point()
x |> mt_track_lines(
  n = dplyr::n()
)
## plot of the tracks as a line
mt_sim_brownian_motion(
  tracks = letters[1:2],
  start_location = list(c(0, 0), c(10, 0))
) |>
  mt_track_lines() |>
  plot()

}
