% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_minimal_time.R
\name{mt_filter_per_interval}
\alias{mt_filter_per_interval}
\alias{mt_per_interval}
\title{Find subset of records based on time windows}
\usage{
mt_filter_per_interval(x, ...)

mt_per_interval(
  x,
  criterion = c("first", "random", "last"),
  unit = "hour",
  ...
)
}
\arguments{
\item{x}{a move2 object}

\item{...}{additional arguments to \code{mt_per_interval} and \code{\link[lubridate]{floor_date}},
for example the day that starts the week}

\item{criterion}{the criterion of what record to select per time interval}

\item{unit}{the time units to select the first record per. This can also be a multiple of units (e.g. "30 seconds").
For more details see \code{\link[lubridate]{floor_date}}}
}
\value{
\code{mt_per_interval} returns a logical vector indicating the selected records. \cr
\code{mt_filter_per_interval} returns a filtered \code{move2} object
}
\description{
\itemize{
\item \code{mt_filter_per_interval}: returns a \code{move2} with the selected records
\item \code{mt_per_interval}: returns a logical vector indicating the selected records
}
}
\examples{
data <- mt_sim_brownian_motion(as.POSIXct("2022-1-1") + 1:10)
data |> mt_filter_per_interval(criterion = "random")
data |> mt_filter_per_interval(unit = "3 secs")
data[mt_per_interval(data, unit = "6 secs"), ]
}
\seealso{
Other filter: 
\code{\link{mt_filter_movebank_visible}()},
\code{\link{mt_filter_unique}()}
}
\concept{filter}
