% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{mt_diffmap}
\alias{mt_diffmap}
\title{Creates a difference-heatmap of two trajectory heatmap images.}
\usage{
mt_diffmap(x, y = NULL, condition = NULL, use = "trajectories",
  dimensions = c("xpos", "ypos"), use2 = "data", filename = NULL,
  bounds = NULL, xres = 500, upscale = 4, smooth_radius = 10,
  colors = c("#00863F", "#000000", "#FF1900"), n_shades = 1000,
  plot = TRUE, ..., verbose = TRUE)
}
\arguments{
\item{x}{an object of class \code{mousetrap}), a trajectory object of class 
\code{array}, or an object of class \code{mt_heatmap_raw} (as created by
\link{mt_heatmap_raw}).}

\item{y}{an object of class \code{mousetrap}), a trajectory object of class 
\code{array}, or an object of class \code{mt_heatmap_raw} (as created by
\link{mt_heatmap_raw}). The class of \code{y} must match the class of 
\code{x}, unless \code{y} is \code{NULL}.}

\item{condition}{either a character value specifying which variable codes the
two conditions (in \code{x[[use2]]}) that should be compared - or a vector
matching the number of trajectories in \code{x[[use]]} that has exactly two
levels. \code{mt_diffmap} will create a difference-heatmap comparing all
trajectories between the two conditions. If \code{condition} is specified,
\code{y} will be ignored (unless \code{x} and \code{y} are of class
\code{heatmap_raw}).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{dimensions}{a character vector specifying the trajectory variables used
to create the heatmap. The first two entries are used as x and 
y-coordinates, the third, if provided, will be added as color information.}

\item{use2}{an optional character string specifying where the data that
contain the condition variable can be found. Defaults to "data" as
\code{x[["data"]]} usually contains all non mouse-tracking trial data.}

\item{filename}{a character string giving the name of the file. If 
\code{NULL} (the default), the R standard device is used for plotting.
Otherwise, the plotting device is inferred from the file extension. Only
supports devices \link[grDevices]{tiff}, \link[grDevices]{png},
\link[grDevices]{pdf}.}

\item{bounds}{numeric vector specifying the corners (xmin, ymin, xmax, ymax) 
of the plot region. By default (\code{bounds = NULL}), bounds are 
determined based on the data input.}

\item{xres}{an integer specifying the number of pixels along the x-dimension.
An \code{xres} of 1000 implies an 1000*N px, where N is determined so that 
the trajectories aspect ratio is preserved (provided the \code{bounds} are 
unchanged).}

\item{upscale}{a numeric value by which the output resolution of the image is
increased or decreased. Only applies if device is one of tiff, png, or pdf.}

\item{smooth_radius}{a numeric value specifying the standard deviation of the
gaussian smoothing. If zero, smoothing is omitted.}

\item{colors}{a character vector specifying the colors used to color
cases of \code{image1 > image2, image1 ~ image2, image1 < image2},
respectively. Note that the colors are used in that specific order.
Defaults to c("#00863F", "#FFFFFF", "#FF1900") which specifies 
a green-black-red color gradient.}

\item{n_shades}{integer specifying the number of shades for the color
gradient between the first and second, and the second and third color in
\code{colors}.}

\item{plot}{logical specifying whether resulting image should be plotted 
(\code{plot = TRUE}, the default). If (\code{plot = FALSE}), an object of
class \code{mt_object_raw} is returned.}

\item{...}{arguments passed to \link{mt_heatmap_raw}.}

\item{verbose}{logical indicating whether function should report its
progress.}
}
\description{
\code{mt_diffmap} creates a difference-heatmap of the trajectory data using
gaussian smoothing. Note that this function has beta status.
}
\details{
\code{mt_diffmap} takes two objects that either contain trajectory heatmaps
or from which trajectory heatmaps can be computed. Difference-heatmaps are
constructed analogously to \link{mt_heatmap_raw}.
}
\examples{
mt_diffmap(KH2017, condition="Condition",
  xres=400, smooth_radius=6, n_shades=5)

}
\references{
Wulff, D. U., Haslbeck, J. M. B., Kieslich, P. J., Henninger, F.,
  & Schulte-Mecklenbeck, M. (in press). Mouse-tracking: Detecting types in
  movement trajectories. In M. Schulte-Mecklenbeck, A. Kuehberger, & J. G.
  Johnson (Eds.), \emph{A Handbook of Process Tracing Methods}. New York:
  Taylor & Francis.

  Kieslich, P. J., Henninger, F., Wulff, D. U., Haslbeck, J. M. B., &
  Schulte-Mecklenbeck, M. (in press). Mouse-tracking: A practical guide to
  implementation and analysis. In M. Schulte-Mecklenbeck, A. Kuehberger, & J.
  G. Johnson (Eds.), \emph{A Handbook of Process Tracing Methods}. New York:
  Taylor & Francis.
}
\seealso{
\link{mt_heatmap} and \link{mt_heatmap_ggplot} for plotting trajectory 
heatmaps.
}
\author{
Dirk U. Wulff (\email{dirk.wulff@gmail.com})

Pascal J. Kieslich
}
