% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosum.R
\name{mosum}
\alias{mosum}
\title{MOSUM procedure for multiple change-point estimation}
\usage{
mosum(x, G, G.right = G, var.est.method = c("mosum", "mosum.min",
  "mosum.max", "custom")[1], var.custom = NULL,
  boundary.extension = TRUE, threshold = c("critical.value",
  "custom")[1], alpha = 0.1, threshold.custom = NULL,
  criterion = c("eta", "epsilon")[1], eta = 0.4, epsilon = 0.2,
  do.confint = FALSE, level = 0.05, N_reps = 1000)
}
\arguments{
\item{x}{input data (a \code{numeric} vector or an object of classes \code{ts} and \code{timeSeries})}

\item{G}{an integer value for the moving sum bandwidth;
\code{G} should be less than \code{length(n)/2}.
Alternatively, a number between \code{0} and \code{0.5} describing the moving sum bandwidth
relative to \code{length(x)} can be given}

\item{G.right}{if \code{G.right != G}, the asymmetric bandwidth \code{(G, G.right)} will be used;}

\item{var.est.method}{how the variance is estimated;
possible values are
\itemize{
   \item{\code{"mosum"}}{both-sided MOSUM variance estimator}
   \item{\code{"mosum.min"}}{minimum of the sample variance estimates from the left and right summation windows}
   \item{\code{"mosum.max"}}{maximum of the sample variance estimates from the left and right summation windows}
   \item{\code{"custom"}}{a vector of \code{length(x)} is to be parsed by the user; use \code{var.custom} in this case to do so}
}}

\item{var.custom}{a numeric vector (of the same length as \code{x}) containing
local estimates of the variance or long run variance; use iff \code{var.est.method = "custom"}}

\item{boundary.extension}{a logical value indicating whether the boundary
values should be filled-up with CUSUM values}

\item{threshold}{string indicating which threshold should be used to determine significance.
By default, it is chosen from the asymptotic distribution at the given significance level \code{alpha}.
Alternatively it is possible to parse a user-defined numerical value with \code{threshold.custom}}

\item{alpha}{a numeric value for the significance level with
\code{0 <= alpha <= 1}; use iff \code{threshold = "critical.value"}}

\item{threshold.custom}{a numeric value greater than 0 for the threshold of significance;
use iff \code{threshold = "custom"}}

\item{criterion}{string indicating how to determine whether each point \code{k} at which MOSUM statistic 
exceeds the threshold is a change-point; possible values are
\itemize{
   \item{\code{"eta"}}{there is no larger exceeding in an \code{eta*G} environment of \code{k}}
   \item{\code{"epsilon"}}{\code{k} is the maximum of its local exceeding environment, which has at least size \code{epsilon*G}}
}}

\item{eta}{a positive numeric value for the minimal mutual distance of 
changes, relative to moving sum bandwidth (iff \code{criterion = "eta"})}

\item{epsilon}{a numeric value in (0,1] for the minimal size of exceeding
environments, relative to moving sum bandwidth (iff \code{criterion = "epsilon"})}

\item{do.confint}{flag indicating whether to compute the confidence intervals for change-points}

\item{level}{use iff \code{do.confint = TRUE}; a numeric value (\code{0 <= level <= 1}) with which
\code{100(1-level)\%} confidence interval is generated}

\item{N_reps}{use iff \code{do.confint = TRUE}; number of bootstrap replicates to be generated}
}
\value{
S3 object of class \code{mosum.cpts}, which contains the following fields:
   \item{x}{input data}
   \item{G.left, G.right}{left and right summation bandwidths}
   \item{var.est.method, var.custom,boundary.extension}{input parameters}
   \item{stat}{a series of MOSUM statistic values; the first \code{G} and last \code{G.right} values are \code{NA} iff \code{boundary.extension = FALSE}}
   \item{rollsums}{a series of MOSUM detector values; equals \code{stat*sqrt(var.estimation)}}
   \item{var.estimation}{the local variance estimated according to \code{var.est.method}}
   \item{threshold, alpha, threshold.custom}{input parameters}
   \item{threshold.value}{threshold value of the corresponding MOSUM test}
   \item{criterion, eta, epsilon}{input parameters}
   \item{cpts}{a vector containing the estimated change-point locations}
   \item{cpts.info}{data frame containing information about change-point estimators including detection bandwidths, asymptotic p-values for the corresponding MOSUM statistics and (scaled) size of jumps}
   \item{do.confint}{input parameter}
   \item{ci}{S3 object of class \code{cpts.ci} containing confidence intervals for change-points iff \code{do.confint=TRUE}}
}
\description{
Computes the MOSUM detector, detects (multiple) change-points and estimates their locations.
}
\examples{
x <- testData(lengths = rep(100, 3), means = c(0, 5, -2), sds = rep(1, 3), seed = 1234)$x
m <- mosum(x, G = 40)
plot(m)
summary(m)
}
\references{
A. Meier, C. Kirch and H. Cho (2019+)
mosum: A Package for Moving Sums in Change-Point Analysis. \emph{Unpublished manuscript}.

B. Eichinger and C. Kirch (2018)
A MOSUM procedure for the estimation of multiple random change-points.
\emph{Bernoulli}, Volume 24, Number 1, pp. 526-564.
}
