% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datagen.R
\name{task.add.random.cols}
\alias{task.add.random.cols}
\title{Add Sampled Noise-Features to Task}
\usage{
task.add.random.cols(task, num, dist = rnorm)
}
\arguments{
\item{task}{\verb{[Task]} the input task.}

\item{num}{\verb{[integer(1)]} number of noise features to add.}

\item{dist}{\verb{[function]} function \code{n} -> \code{numeric(n)} that samples
random noise features.}
}
\value{
\code{\link{Task}}
}
\description{
Adds \code{num} new features sampled from \code{dist} to \code{task}.
New features are inserted at random positions in the task
and named \code{RANDOM.1}...\code{RANDOM.[num]}

The returned \code{\link{Task}} has a \verb{$orig.features} which
is a logical vector indicating the features that were originally
in the \code{Task}.

If the \verb{$orig.features} slot is already present in
the input \code{task}, then the output will have added \code{FALSE} entries at
appropriate positions.
}
\seealso{
Other Artificial Datasets: 
\code{\link{clonetask}()},
\code{\link{create.hypersphere.data}()},
\code{\link{create.linear.data}()},
\code{\link{create.linear.toy.data}()},
\code{\link{create.regr.task}()},
\code{\link{task.add.permuted.cols}()}
}
\concept{Artificial Datasets}
