% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{overallRankMO}
\alias{overallRankMO}
\title{Rank by Nondominated Front and Crowding Distance or Hypervolume Contribution}
\usage{
overallRankMO(fitness, sorting = "crowding", ref.point)
}
\arguments{
\item{fitness}{\verb{[matrix]} fitness matrix, one column per individual.}

\item{sorting}{\verb{[character(1)]} one of \code{"domhv"} or \code{"crowding"} (default).}

\item{ref.point}{\verb{[numeric]} reference point for hypervolume, must be given
if \code{sorting} is \code{"domhv"}.}
}
\value{
\verb{[integer]} vector of ranks with length \code{ncol(fitness)}, lower ranks are
associated with individuals that tend to dominate more points and that tend to
have larger crowding distance or hypervolume contribution.
}
\description{
Rank individuals by nondominating sorted front first and by hypervolume contribution
or crowding distance second.

Ties are broken randomly by adding random noise of relative magnitude
\code{.Machine$double.eps * 2^10} to points.
}
