% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{mutUniformParametric}
\alias{mutUniformParametric}
\alias{mutUniformParametricScaled}
\alias{mutUniformParametricInt}
\alias{mutUniformParametricIntScaled}
\title{Parametric Uniform  Mutation}
\usage{
mutUniformParametric(ind, p, lx, lower, upper)

mutUniformParametricScaled(ind, p, sdev, lower, upper)

mutUniformParametricInt(ind, ..., lower, upper)

mutUniformParametricIntScaled(ind, ..., lower, upper)
}
\arguments{
\item{ind}{\verb{[numeric | integer]} individual to mutate.}

\item{p}{\verb{[numeric]} per-entry probability to perform mutation.}

\item{lx}{\verb{[numeric]} uniform distribution bandwidth.}

\item{lower}{\verb{[integer]} lower bounds of \code{ind} values. May have same length as
\code{ind} or may be a single number, if the lower bounds are the same for all
values.}

\item{upper}{\verb{[integer]} upper bounds of \code{ind} values. May have same length as
\code{ind} or may be a single number, if the upper bounds are the same for all
values.}

\item{sdev}{\verb{[numeric]} standard deviation, will be scaled to \code{upper - lower}.}

\item{...}{further arguments passed on to the method.}
}
\value{
\verb{[numeric | integer]} mutated individual.
}
\description{
Adds a variable \code{delta} to each component \code{ind[i]}
with probability \code{p}, where \code{delta} is uniformly
distributed between \code{pmax(lower - ind[x], -lx/2)} and
\code{pmin(upper - ind[i], lx/2)}.
}
