% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtermat.R
\name{makeFilterMat}
\alias{makeFilterMat}
\title{Create a Filter-Matrix}
\usage{
makeFilterMat(
  task,
  filters,
  expectfeatfrac = 0.5,
  expectfeats = getTaskNFeats(task) * expectfeatfrac,
  minprob = 0,
  maxprob = 1
)
}
\arguments{
\item{task}{\verb{[Task]} The task to generate filter information for.}

\item{filters}{\verb{[character]} The filters to use. Special vilter \code{"DUMMY"}
gives a constant column of \code{expectfeatfrac}.}

\item{expectfeatfrac}{\verb{[numeric(1)]} The expected fraction of features to have in equilibrium. Ignored if \code{expectfeats} is given.}

\item{expectfeats}{\verb{[numeric(1)]} The expected number of features to have in equilibrium.}

\item{minprob}{\verb{[numeric(1)]} The minimum probability for each feature.}

\item{maxprob}{\verb{[numeric(1)]} The maximum probability for each feature.}
}
\value{
\code{matrix}
}
\description{
A Filter-Matrix can be used in combination with \code{\link{mutUniformMetaReset}} for
heuristic-supported biased mutation.
}
\examples{
library("mlr")

# Example for iris task
filters <- c("praznik_JMI", "anova.test", "variance", "DUMMY")
fima <- makeFilterMat(iris.task, filters = filters)
print(fima)

}
