% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulas.R
\name{formularise}
\alias{formularise}
\title{Convert lazy objects into formulas}
\usage{
formularise(lazy_formula, envir = parent.frame())
}
\arguments{
\item{lazy_formula}{an object of class \code{lazy}}

\item{envir}{an environment that will be come the environment of the returned formula}
}
\value{
a formula
}
\description{
Convert lazy objects into a formula
}
\details{
The expression of the lazy object is evaluated in its environment.  If the
result is not a formula, then the formula is created with an empty left hand side
and the expression on the right hand side.
}
\examples{
formularise(lazyeval::lazy(foo))
formularise(lazyeval::lazy(y ~ x))
bar <- a ~ b
formularise(lazyeval::lazy(bar))
}
