% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qspliner.R
\name{qspliner}
\alias{qspliner}
\title{Create a quadratic spline (inefficiently)}
\usage{
qspliner(tilde, data, free = 0)
}
\arguments{
\item{tilde}{A tilde expression of the form \code{y ~ x} specifying the output variable (on the LHS)
and the input variable (on the RHS). Together with \code{data}, these (x,y) pairs will be the
knots for the spline.}

\item{data}{A data frame containing the variables in \code{tilde}.}

\item{free}{A number specifying the slope of the output function at the last knot. Default is 0: that is, flat.}
}
\value{
a function suitable for, for instance, graphing or optimizing
}
\description{
A handmade function to construct quadratic splines.
}
\details{
Unless you have a good reason otherwise, you should be using \code{spliner()},
which generates cubic splines,
rather than \code{qspliner()}.  \code{qspliner()} is intended only for demonstration purposes.
}
\examples{
Pts <- tibble(x = seq(-4,4, by=.7), y = dnorm(x))
f <- qspliner(y ~ x, data = Pts)
slice_plot(dnorm(x) ~ x, domain(x=-4:4)) \%>\%
  slice_plot(f(x) ~ x, color= "blue") \%>\%
  gf_point(y ~ x, data = Pts, color = "orange", size=4, alpha=0.3) \%>\%
  gf_lims(y= c(NA,.5))
}
