% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2matrix.R
\name{df2matrix}
\alias{df2matrix}
\title{Construct a model matrix from data as if by hand}
\usage{
df2matrix(..., data = NULL)
}
\arguments{
\item{\dots}{Expressions, written in terms of the variable names in the data frame,
that are to be collected into the model matrix.}

\item{data}{The data frame from which to which the variable names will be bound.}
}
\description{
The \emph{MOSAIC Calculus} course includes a block on linear algebra.
As part of this block, we want to cover creating model matrices and evaluating
the model constructed from them. One way to do this is to introduce
\code{lm()} and the domain specific language for specifying model terms. However,
that introduces oddities. For instance, \code{lm(mpg ~ hp + hp^2, data = mtcars)} does
NOT add the quadratic term to the model matrix. Also, \code{lm()} doesn't produce
a residual or the model vector (ahem ... the fitted values) in the form of vectors.
That's fine if you're teaching statistical modeling, but in the \emph{MOSAIC Calculus}
linear algebra block we are not teaching statistics, but the mathematical
pre-requisites to understanding statistics.
}
\details{
Specifically for \emph{MOSAIC Calculus}, we have added this \code{df2matrix()} function.
It serves much the same purpose as \code{cbind()}, that is, collecting vectors into a
matrix. But is has two additional features:
\enumerate{
\item It has a \verb{data=} argument so that it can refer to a data frame.
\item It names the columns of the matrix with the code that was used to create
each column.
}

The consequence of (2) is that the \code{x} vector produced by \code{qr.solve()} will have the
same names as the matrix. That helps in interpreting \code{x}. But those names
can also be used by \code{makeFun()} to generate a function from \code{x}.

\code{1} is a good form in which to write the intercept term.
}
\examples{
A <- df2matrix(1, disp, log(hp), sin(cyl)*sqrt(hp), data = mtcars)
b <- df2matrix(mpg, data = mtcars)
x <- qr.solve(A, b)
f <- makeFun(x)
f(hp=3, disp=2, cyl=4)

}
