% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps2.R
\name{standardName}
\alias{standardName}
\alias{standardCountry}
\alias{standardState}
\title{Standardization of Geographic Names}
\usage{
standardName(x, standard, ignore.case = TRUE, returnAlternatives = FALSE,
  quiet = FALSE)

standardCountry(x, ignore.case = TRUE, returnAlternatives = FALSE,
  quiet = FALSE)

standardState(x, ignore.case = TRUE, returnAlternatives = FALSE,
  quiet = FALSE)
}
\arguments{
\item{x}{A vector with the region names to standardize}

\item{standard}{a named vector providing the map from
non-standard names (names of vector) to standard names (values of vector)}

\item{ignore.case}{a logical indicating whether case should be ignored
when matching.}

\item{returnAlternatives}{a logical indicating whether all alternatives should
be returned in addition to the standard name.}

\item{quiet}{a logical indicating whether warnings should be suppressed}
}
\description{
Often different sources of geographical data will use different names for
the same region.  These utilities make it easier to merge data from different
sources by converting names to standardized forms.
}
\details{
\describe{

\item{standardName}{This is the most general standardizing function.
In addition to \code{x}, this function requires another argument:
\code{standard} - a named vector in which each name is a particular
spelling of the region name in question and the corresponding value
is the standardized version of that region name}

\item{standardCountry}{This function will standardize the country
names in \code{x} to the standard ISO_a3 country code format. If
\code{returnAlternatives} is set to \code{TRUE}, this function will also
return the the named vector used to standardize the country names}

\item{standardState}{This function will standardize the US state
names in \code{x} to the standard two-letter abbreviations. If
\code{returnAlternatives} is set to \code{TRUE}, this function will also
return the the named vector used to standardize the state names}
}
In all three cases, any names not found in \code{standard}
will be left unaltered.  Unless supressed, a warning message will
indicate the number of such cases, if there are any.
}
