% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/props-counts.R
\name{counts}
\alias{counts}
\alias{counts.default}
\alias{counts.formula}
\alias{props}
\alias{percs}
\title{Compute all proportions or counts}
\usage{
counts(x, ...)

\method{counts}{default}(x, ..., format = c("count", "proportion", "percent"))

\method{counts}{formula}(x, data, ..., format = "count")

props(x, ..., format = "proportion")

percs(x, ..., format = "percent")
}
\arguments{
\item{x}{A vector or a formula.}

\item{...}{Arguments passed to methods.}

\item{format}{One of \code{"count"}, \code{"proportion"}, or \code{"percent"}.  May be abbreviated.}

\item{data}{A data frame.}
}
\description{
Compute vector of counts, proportions, or percents for each unique value (and \code{NA} if there
is missing data) in a vector.
}
\examples{
props(HELPrct$substance)
# Formula version removes missing data (for now, may change this in future versions)
props(HELPmiss$link)
props( ~ link, data = HELPmiss)
tally( ~ link, data = HELPmiss, format = "prop")
props( ~ substance | sex, data = HELPrct)
props( ~ substance | sex, data = HELPrct, format = "percent")
counts( ~ substance | sex, data = HELPrct)
if (require(ggformula)) {
  df_stats( ~ substance | sex, data = HELPrct, props, counts)
}

}
\seealso{
\code{\link{prop}()}

\code{\link{count}()}
}
