% Generated by roxygen2 (4.0.2): do not edit by hand
\name{bargraph}
\alias{bargraph}
\title{Create bar graphs from raw data}
\usage{
bargraph(x, data = parent.frame(), groups, horizontal = FALSE, origin = 0,
  ylab = ifelse(horizontal, "", "Frequency"), xlab = ifelse(horizontal,
  "Frequency", ""), subset, ...)
}
\arguments{
\item{x}{a formula describing the plot}

\item{data}{a data frame in which the formula \code{x} is evaluated}

\item{groups}{a variable or expression used for grouping.  See \code{\link[lattice]{barchart}}.}

\item{horizontal}{a logical indicating whether bars should be horizontal}

\item{origin}{beginning point for bars.  For the default behavior used by
\code{\link[lattice]{barchart}} set \code{origin} to \code{NULL}, but
 0 is often a better default. If 0 is not good, perhaps you should use
a different kind of plot as the results may be misleading.}

\item{ylab}{a character vector of length one used for the y-axis label}

\item{xlab}{a character vector of length one used for the x-axis label}

\item{subset}{a vector used to subset \code{data}.  This may be an expression that
will be evaluated within \code{data}.}

\item{\dots}{additional arguments passed to \code{\link[lattice]{barchart}}}
}
\value{
a trellis object describing the plot
}
\description{
\code{\link[lattice]{barchart}} from the \code{lattice} package makes bar graphs from
pre-tabulated data.  Raw data can be tabulated using \code{\link{xtabs}}, but the syntax
is unusual compared to the other lattice plotting functions.  \code{bargraph} provides
an interface that is consistent with the other \code{lattice} functions.
}
\details{
\code{bargraph(formula, data=data, ...)} works by creating a new data frame from \code{xtabs(formula, data=data)}
and then calling \code{\link[lattice]{barchart}} using modified version of the formula and this
new data frame as inputs.  This has implications on, for example, conditional plots where
one desires to condition on some expression that will be evaluated in \code{data}.  This typically
does not work becuase the required variables do not exist in the output of \code{xtabs}.  One solution
is to first add a new variable to \code{data} first and then to condition using this new variable.
See the examples.
}
\examples{
if (require(mosaicData)) {
data(HELPrct)
bargraph( ~ substance, data=HELPrct)
bargraph( ~ substance, data=HELPrct, horizontal=TRUE)
bargraph( ~ substance | sex, groups=homeless, auto.key=TRUE, data=HELPrct)
bargraph( ~ substance, groups=homeless, auto.key=TRUE, data=HELPrct, subset=sex=="male")
HELPrct2 <- transform( HELPrct, older = age > 40 )
bargraph( ~ substance | older, data = HELPrct2 )
}
}
\seealso{
\code{\link[lattice]{barchart}}
}

