% Generated by roxygen2 (4.0.0): do not edit by hand
\name{rflip}
\alias{nflip}
\alias{print.cointoss}
\alias{rflip}
\title{Tossing Coins}
\usage{
rflip(n = 1, prob = 0.5, quiet = FALSE, verbose = !quiet)

\method{print}{cointoss}(x, ...)

nflip(n = 1, prob = 0.5, ...)
}
\arguments{
  \item{n}{the number of coins to toss}

  \item{prob}{probability of heads on each toss}

  \item{quiet}{a logical.  If \code{TRUE}, less verbose
  output is used.}

  \item{verbose}{a logical.  If \code{TRUE}, more verbose
  output is used.}

  \item{x}{an object}

  \item{\dots}{additional arguments}
}
\value{
for \code{rflip}, a cointoss object

for \code{nflip}, a numeric vector
}
\description{
These functions simplify simulating coin tosses for those (students primarily)
who are not yet familair with the binomial distributions or just like this syntax
and verbosity better.
}
\examples{
rflip(10)
rflip(10, prob=1/6, quiet=TRUE)
do(5) * rflip(10)
as.numeric(rflip(10))
nflip(10)
}

