% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc.survFitTT.R
\name{ppc.survFitTT}
\alias{ppc.survFitTT}
\title{Posterior predictive check plot for \code{survFitTT} objects}
\usage{
\method{ppc}{survFitTT}(x, style = "ggplot", main = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{survFitTT}}

\item{style}{graphical backend, can be \code{'generic'} or \code{'ggplot'}}

\item{main}{main title for the plot}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This is the generic \code{ppc} S3 method for the \code{survFitTT} class. It
plots the predicted values with 95 \% credible intervals versus the observed
values for \code{survFitTT} objects.
}
\details{
The coordinates of black points are the observed values of the number of survivors
(pooled replicates) for a given concentration (\eqn{X}-axis) and the corresponding 
predicted values (\eqn{Y}-axis). 95\% prediction intervals are added to each predicted
value, colored in green if this interval contains the observed value and in red
otherwise.
The bisecting line (y = x) is added to the plot in order to see if each
prediction interval contains each observed value. As replicates are shifted
on the x-axis, this line is represented by steps.
}
\examples{

# (1) Load the data
data(cadmium1)

# (2) Create an object of class "survData"
dat <- survData(cadmium1)

\dontrun{
# (3) Run the survFitTT function with the log-logistic binomial model
out <- survFitTT(dat, lcx = c(5, 10, 15, 20, 30, 50, 80),
quiet = TRUE)

# (4) Plot observed versus predicted values
ppc(out)
}

}
