\name{plo_sup}
\alias{plo_sup}

\title{
Plot of Supplementary Variables
}

\description{
Plots the categories of supplementary variables for a PLS regression.
}

\usage{
plo_sup(object, vars, excl = NULL, comps = c(1,2),
 shapesize = 2, textsize = 3, vlab = TRUE, force = 1,
 max.overlaps = Inf, dashes = TRUE)
}

\arguments{
  \item{object}{an object of class \code{mvr} from \code{pls} package}
  \item{vars}{A data frame of categorical supplementary variables. All these variables should be factors.}
  \item{excl}{character vector of supplementary categories to exclude from the plot, specified in the form "namevariable.namecategory" (for instance "Gender.Men"). If NULL (default), all the supplementary categories are plotted.}
  \item{comps}{the components to use. Default is \code{c(1,2)}.}
  \item{shapesize}{Size of the shapes. Default is 2.}
  \item{textsize}{Size of the labels of categories. Default is 3.}
  \item{vlab}{Logical. If TRUE (default), the variable name is added as a prefix for the labels of the categories.}
  \item{force}{Force of repulsion between overlapping text labels. Defaults to 1. If 0, labels are not repelled at all.}
  \item{max.overlaps}{Exclude text labels that overlap too many things. Defaults to Inf, which means no labels are excluded.}
  \item{dashes}{Logical. Should one add lines between categories ? Default is TRUE.}
}

\value{
a \code{ggplot2} object
}

\references{
Martens, H., Næs, T. (1989) Multivariate calibration. Chichester: Wiley.

Tenenhaus, M. (1998) La Regression PLS. Theorie et Pratique. Editions TECHNIP, Paris.
}

\author{
Nicolas Robette
}

\seealso{
\code{\link{plo_var}}
}

\examples{
library(pls)
data(mpg, package = "ggplot2")
pls <- mvr(displ ~ cty + hwy + cyl,
           ncomp = 3,
           data = mpg,
           validation = "CV",
           method = "oscorespls")
supvars <- data.frame(class = factor(mpg$class), trans = factor(mpg$trans))
plo_sup(pls, supvars, dashes = FALSE)
}

\keyword{ multivariate }
\keyword{ misc }
