% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symdevplot.R
\name{symdevplot}
\alias{symdevplot}
\title{Plot the symmetric deviation function.}
\usage{
symdevplot(
  x,
  sets,
  VE,
  threshold,
  nlevels = 11,
  ve.col = "blue",
  xlim = NULL,
  ylim = NULL,
  legend.pos = "topright",
  main = "Symmetric deviation function",
  col.fun = function(n) gray(seq(0, 0.9, length.out = n)^2)
)
}
\arguments{
\item{x}{\code{matrix()}|\code{data.frame()}\cr Matrix or data frame of numerical
values, where each row gives the coordinates of a point. If \code{sets} is
missing, the last column of \code{x} gives the sets.}

\item{sets}{\code{integer()}\cr A vector that indicates the set of each point in \code{x}. If
missing, the last column of \code{x} is used instead.}

\item{VE, threshold}{Vorob'ev expectation and threshold, e.g., as returned
by \code{\link[moocore:Vorob]{moocore::vorobT()}}.}

\item{nlevels}{(\code{integer(1)})\cr Number of levels in which is divided the range of the
symmetric deviation.}

\item{ve.col}{Plotting parameters for the Vorob'ev expectation.}

\item{xlim, ylim, main}{Graphical parameters, see
\code{\link[graphics:plot.default]{plot.default()}}.}

\item{legend.pos}{The position of the legend, see
\code{\link[graphics:legend]{legend()}}. A value of \code{"none"} hides the legend.}

\item{col.fun}{Function that creates a vector of \code{n} colors, see
\code{\link[grDevices:palettes]{heat.colors()}}.}
}
\value{
No return value, called for side effects
}
\description{
The symmetric deviation function is the probability for a given target in
the objective space to belong to the symmetric difference between the
Vorob'ev expectation and a realization of the (random) attained set.
}
\examples{
data(CPFs, package = "moocore")
res <- moocore::vorobT(CPFs, reference = c(2, 200))
print(res$threshold)

## Display Vorob'ev expectation and attainment function
# First style
eafplot(CPFs[,1:2], sets = CPFs[,3], percentiles = c(0, 25, 50, 75, 100, res$threshold),
        main = substitute(paste("Empirical attainment function, ",beta,"* = ", a, "\%"),
                          list(a = formatC(res$threshold, digits = 2, format = "f"))))

# Second style
eafplot(CPFs[,1:2], sets = CPFs[,3], percentiles = c(0, 20, 40, 60, 80, 100),
        col = gray(seq(0.8, 0.1, length.out = 6)^0.5), type = "area",
        legend.pos = "bottomleft", extra.points = res$VE, extra.col = "cyan",
        extra.legend = "VE", extra.lty = "solid", extra.pch = NA, extra.lwd = 2,
        main = substitute(paste("Empirical attainment function, ",beta,"* = ", a, "\%"),
                          list(a = formatC(res$threshold, digits = 2, format = "f"))))
# Vorob'ev deviation
VD <- moocore::vorobDev(CPFs, reference = c(2, 200), VE = res$VE)
# Display the symmetric deviation function.
symdevplot(CPFs, VE = res$VE, threshold = res$threshold, nlevels = 11)
# Levels are adjusted automatically if too large.
symdevplot(CPFs, VE = res$VE, threshold = res$threshold, nlevels = 200, legend.pos = "none")

# Use a different palette.
symdevplot(CPFs, VE = res$VE, threshold = res$threshold, nlevels = 11, col.fun = heat.colors)

}
\references{
\insertRef{BinGinRou2015gaupar}{moocore}

C. Chevalier (2013), Fast uncertainty reduction strategies relying on
Gaussian process models, University of Bern, PhD thesis.

\insertRef{Molchanov2005theory}{moocore}
}
\seealso{
\code{\link[moocore:Vorob]{moocore::vorobT()}} \code{\link[moocore:Vorob]{moocore::vorobDev()}} \code{\link[=eafplot]{eafplot()}}
}
\author{
Mickael Binois
}
\concept{eaf}
