% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{differential_score}
\alias{differential_score}
\title{The absolute difference of interaction score of two groups}
\usage{
differential_score(interaction_score_graphs, score_name = "weight")
}
\arguments{
\item{interaction_score_graphs}{Named list with elements `group1` and
`group2` containing iGraph objects with score as edge attribute. Output of
\code{\link{interaction_score}}.}

\item{score_name}{Character string specifying the name of the edge
attribute (default: `weight`).}
}
\value{
iGraph object with `differential_score` as only edge attribute
}
\description{
Computes the absolute difference of interaction score between
two groups. Returns a single graph with the differential score as only edge
attribute. The interaction score is computed by \code{\link{interaction_score}}.
}
\examples{
data(interaction_score_graphs_example)
interaction_score_graphs <- interaction_score_graphs_example
differential_score_graph <- differential_score(interaction_score_graphs, score_name = "weight")

}
