% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/read.AVIZO.ply.R
\name{read.AVIZO.ply}
\alias{read.AVIZO.ply}
\title{Read mesh data from ply files saved by AVIZO}
\usage{
read.AVIZO.ply(file, ShowSpecimen = TRUE, addNormals = TRUE)
}
\arguments{
\item{file}{An ASCII PLY file generated by Avizo}

\item{ShowSpecimen}{Logical indicating whether or not the
mesh should be displayed}

\item{addNormals}{Logical indicating whether or not normals of
mesh vertices shold be calculated and appended to object}
}
\description{
A function that reads Stanford ply files as saved by the 3D data
visualization software Avizo
}
\details{
If \code{ShowSpecimen} is True, a gray \code{shade3d} of the mesh is generated in
a new rgl window for previewing the specimen. When saving to the ply file type,
Avizo inserts additional property parameters into the file heading that
sometimes describe various components of the mesh. These additional properties
cause the \code{read.ply} function native to the \code{geomorph} package to fail. This function
properly reads ply files generated by Avizo (like \code{read.ply}) and can be stored as an
object accepted as input in the other \code{molaR} functions. Ply files generated through
other software (such as MeshLab) can be read using \code{read.ply}.
}

