% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_vmpf.R
\name{predict_front}
\alias{predict_front}
\title{Predicted Pareto front}
\usage{
predict_front(model, lower, upper, control = NULL, modelcontrol = NULL)
}
\arguments{
\item{model}{Object of class \code{\link{mkm}}.}

\item{lower}{Vector of lower bounds for the variables to be optimized over
(default: 0 with length \code{model@d}).}

\item{upper}{Vector of upper bounds for the variables to be optimized over
(default: 1 with length \code{model@d}).}

\item{control}{An optional list of control parameters that controls the
optimization algorithm. One can control: \describe{
\item{\code{popsize}}{(default: \code{200});}
\item{\code{generations}}{(default: \code{30});}
\item{\code{cdist}}{(default: \code{1/model@d});}
\item{\code{mprob}}{(default: \code{15});}
\item{\code{mdist}}{(default: \code{20}).}
}}

\item{modelcontrol}{An optional list of control parameters to the
\code{mkm} function (default: \code{object@control}).}
}
\value{
object of class \code{\link{ps}} containing the predicted Pareto front
}
\description{
This function creates a predicted pareto front based on the mean of Kriging
models. The predicted mean of each objective and constraint is passed to the
\code{\link[mco]{nsga2}} algorithm that builds .
}
\examples{
# ------------------------
# The Nowacki Beam
# ------------------------
n <- 100
doe <- cbind(sample(0:n,n),sample(0:n,n))/n
res <- t(apply(doe, 1, nowacki_beam))
model <- mkm(doe, res, modelcontrol = list(objective = 1:2, lower=c(0.1,0.1)))
pf <- predict_front(model, c(0,0), c(1,1))
plot(nowacki_beam_tps$set)
points(pf$set, col='blue')
}
