% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modi-internal.R
\name{ER.normal}
\alias{ER.normal}
\title{Utility for ER function}
\usage{
ER.normal(data, weights = rep(1, nrow(data)), psi.par = c(2, 1.25),
  np = sum(weights), p = ncol(data), s.counts, s.id, S, missing.items,
  nb.missing.items, start.mean = rep(0, p), start.var = diag(1, p),
  numb.it = 10, Estep.output = FALSE, tolerance = 1e-06)
}
\arguments{
\item{data}{matrix or dataframe with data.}

\item{weights}{vector of weights.}

\item{psi.par}{parameters for psi function.}

\item{np}{np.}

\item{p}{number of columns.}

\item{s.counts}{s.counts.}

\item{s.id}{s.id.}

\item{S}{S.}

\item{missing.items}{missing items.}

\item{nb.missing.items}{number of missing items.}

\item{start.mean}{initial center.}

\item{start.var}{initial variance.}

\item{numb.it}{number of iterations.}

\item{Estep.output}{Estep.output.}

\item{tolerance}{tolerance.}
}
\description{
The \code{ER} function is an implementation of the
ER-algorithm of Little and Smith (1987).
}
\author{
Beat Hulliger
}
\keyword{internal}
