% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-fit-workflowset.R
\name{modeltime_fit_workflowset}
\alias{modeltime_fit_workflowset}
\title{Fit a \code{workflowset} object to one or multiple time series}
\usage{
modeltime_fit_workflowset(
  object,
  data,
  ...,
  control = control_fit_workflowset()
)
}
\arguments{
\item{object}{A workflow_set object, generated with the workflowsets::workflow_set function.}

\item{data}{A \code{tibble} that contains data to fit the models.}

\item{...}{Not currently used.}

\item{control}{An object used to modify the fitting process. See \code{\link[=control_fit_workflowset]{control_fit_workflowset()}}.}
}
\value{
A Modeltime Table containing one or more fitted models.
}
\description{
This is a wrapper for \code{fit()} that takes a
\code{workflowset} object and fits each model on one or multiple
time series either sequentially or in parallel.
}
\examples{
library(tidymodels)
library(workflowsets)
library(dplyr)
library(lubridate)
library(timetk)

data_set <- m4_monthly

# SETUP WORKFLOWSETS

rec1 <- recipe(value ~ date + id, data_set) \%>\%
    step_mutate(date_num = as.numeric(date)) \%>\%
    step_mutate(month_lbl = lubridate::month(date, label = TRUE)) \%>\%
    step_dummy(all_nominal(), one_hot = TRUE)

mod1 <- linear_reg() \%>\% set_engine("lm")

mod2 <- prophet_reg() \%>\% set_engine("prophet")

wfsets <- workflowsets::workflow_set(
    preproc = list(rec1 = rec1),
    models  = list(
        mod1 = mod1,
        mod2 = mod2
    ),
    cross   = TRUE
)

# FIT WORKFLOWSETS
# - Returns a Modeltime Table with fitted workflowsets

wfsets \%>\% modeltime_fit_workflowset(data_set)

}
\seealso{
\code{\link[=control_fit_workflowset]{control_fit_workflowset()}}
}
