% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-recursive.R
\name{predict.recursive}
\alias{predict.recursive}
\title{Recursive Model Predictions}
\usage{
\method{predict}{recursive}(object, new_data, type = NULL, opts = list(), ...)
}
\arguments{
\item{object}{An object of class \code{model_fit}}

\item{new_data}{A rectangular data object, such as a data frame.}

\item{type}{A single character value or \code{NULL}. Possible values
are "numeric", "class", "prob", "conf_int", "pred_int", "quantile", "time",
"hazard", "survival", or "raw". When \code{NULL}, \code{predict()} will choose an
appropriate value based on the model's mode.}

\item{opts}{A list of optional arguments to the underlying
predict function that will be used when \code{type = "raw"}. The
list should not include options for the model object or the
new data being predicted.}

\item{...}{Arguments to the underlying model's prediction
function cannot be passed here (see \code{opts}). There are some
\code{parsnip} related options that can be passed, depending on the
value of \code{type}. Possible arguments are:
\itemize{
\item \code{level}: for \code{type}s of "conf_int" and "pred_int" this
is the parameter for the tail area of the intervals
(e.g. confidence level for confidence intervals).
Default value is 0.95.
\item \code{std_error}: add the standard error of fit or prediction (on
the scale of the linear predictors) for \code{type}s of "conf_int"
and "pred_int". Default value is \code{FALSE}.
\item \code{quantile}: the quantile(s) for quantile regression
(not implemented yet)
\item \code{time}: the time(s) for hazard and survival probability estimates.
}}
}
\value{
Numeric values for the recursive panel prediction
}
\description{
Make predictions from a recursive model.
}
\details{
Refer to \code{\link[=recursive]{recursive()}} for further details and examples.
}
