% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-leaderboard.R
\name{automl_leaderboard}
\alias{automl_leaderboard}
\alias{automl_update_model}
\title{H2O AutoML Leaderboard Utilities}
\usage{
automl_leaderboard(object)

automl_update_model(object, model_id)
}
\arguments{
\item{object}{An object created by \code{\link[=automl_reg]{automl_reg()}} and trained (fitted).}

\item{model_id}{An H2O Model ID (shown in the AutoML Leaderboard).
Alternatively, the user can provide an H2O model.}
}
\value{
\itemize{
\item \code{automl_leaderboard()}: A \code{tibble} containing the H2O AutoML Leaderboard
\item \code{automl_update_model()}: An updated \code{parnsip} or \code{workflow} with the H2O Model updated
}
}
\description{
The H2O AutoML Leaderboard lists any models that have been created during the \code{automl_reg()}
training process.
\itemize{
\item The training process automatically uses the top model.
\item The available models can be shown with \code{automl_leaderboard()}
\item The model change the model used using \code{automl_update_model()}.
}
}
\examples{
\dontrun{
library(tidymodels)
library(modeltime.h2o)
library(h2o)
library(tidyverse)
library(timetk)

h2o.init(
    nthreads = -1,
    ip       = 'localhost',
    port     = 54321
)

# Model Spec
model_spec <- automl_reg(mode = 'regression') \%>\%
    set_engine(
        engine                     = 'h2o',
        max_runtime_secs           = 5, 
        max_runtime_secs_per_model = 4,
        nfolds                     = 5,
        max_models                 = 3,
        exclude_algos              = c("DeepLearning"),
        seed                       = 786
    ) 


# Fit AutoML
model_fit <- model_spec \%>\%
    fit(value ~ ., data = training(m750_splits))

# Inspect the Leaderboard
leaderboard_tbl <- automl_leaderboard(model_fit)
leaderboard_tbl

# Swap an H2O Model Out (Using the 2nd model from the leaderboard)
model_id_2  <- leaderboard_tbl$model_id[[2]]
model_fit_2 <- automl_update_model(model_fit, model_id_2)
model_fit_2

# Shutdown H2O when Finished. 
# Make sure to save any work before. 
h2o.shutdown(prompt = FALSE)
    
    
}
  
}
